/*
** Options for AMICUS configuration, based on Kate's NWGOA/nwgoa.h.
*/

#define  ICESHELF     /* Dinniman et al. 2007, 2011 */
#define  ICESHELF_3EQ /* Holland & Jenkins 1999 JPO */
#define  LTIDES       /* Activate tidal forcings.   */
#undef   BIOLOGY
/* The transfer coefficients computed from Schmidt et al. (Ocean Mod. 2004) work
 * fine for Abbot,Cosgrove,PIG,Thwaites, but they lead to basal melt rates under
 * Dotson,Crosson,Getz that are slightly too high. The CPP flags below scale
 * the transfer coefficients computed under these 3 ice shelves by a fixed
 * fraction (see e.g. Nakayama et al. 2017.) */
#define  REDUCE_GAMMA_TS_GETZ
#define  REDUCE_GAMMA_TS_DOTSON_CROSSON

/* General. */

#define  SOLVE3D
#define  SALINITY
#define  NONLIN_EOS
#define  MASKING
#define  RI_SPLINES   /* "Splines reconstruction for vertical shear" */
#define  UV_ADV
#define  UV_COR
#define  UV_QDRAG
#define  CURVGRID     /*N.B. Necessary for ROMS to compute wind rotation*/

#undef   WET_DRY
#undef   SPLINES_VDIFF
#undef   SPLINES_VVISC
#undef   FLOATS
#undef   STATIONS
#undef   IMPLICIT_NUDGING /*"Implicit nudging term in momentum radiation" */

/* Basic numerics options. */

#define  SINGLE_PRECISION
#define  LIMIT_BSTRESS
#define  DJ_GRADPS
#define  UV_VIS2
#define  TS_DIF2

#ifdef   UV_VIS2
# define MIX_S_UV
#endif
#ifdef   TS_DIF2
# define MIX_GEO_TS
#endif

#undef   VISC_3DCOEF
#undef   VISC_GRID /*Scale viscosity coefficient by grid size*/
#undef   SPONGE
#undef   DIFF_GRID

/* Vertical mixing */

#define  LMD_MIXING
#undef   GLS_MIXING
#undef   MY25_MIXING

#if defined GLS_MIXING || defined MY25_MIXING
# define KANTHA_CLAYSON
# define N2S2_HORAVG
# define CRAIG_BANNER
# define CHARNOK

# undef  GERBI_TKE_FLUX
# undef  AKLIMIT
#endif

#ifdef   LMD_MIXING
# define LMD_SKPP     /*surface boundary layer KPP mixing*/
# define LMD_RIMIX    /*add diffusivity due to shear instability*/
# define LMD_BKPP     /*bottom boundary layer KPP mixing*/
# define LMD_CONVEC   /*add convective mixing due to shear instability*/
# define LMD_NONLOCAL /*nonlocal transport*/
# define LMD_DDMIX    /*add double-diffusive mixing*/

# undef  LMD_SHAPIRO  /*Shapiro filtering boundary layer depth*/
#endif

/* See https://www.myroms.org/projects/src/ticket/736
 * (mitigates numerical instabilities in SGS scheme).*/
#define  LIMIT_VDIFF
#define  LIMIT_VVISC

/* Surface forcing. */

#define  BULK_FLUXES
#undef   CCSM_FLUXES    /*Replaces BULK_FLUXES if activated.*/

#if defined BULK_FLUXES || defined CCSM_FLUXES
# define LONGWAVE_OUT
# define SOLAR_SOURCE
# define EMINUSP
# define SPECIFIC_HUMIDITY /*See note about humidity below.*/
# define ALBEDO            /*Activated when ALBEDO_CSIM is activated; see Include/globaldefs.h*/

# undef  ALBEDO_CURVE   /* for water; "albedo function of lat from Large and Yeager"*/
# undef  ALBEDO_CSIM    /* for ice  ; "albedo function from CSIM for ice           "*/
# undef  ALBEDO_FILE    /* for both ; "albedo read from a file" */
# undef  ALBEDO_CLOUD   /* "albedo equation for shortwave radiation" */
# undef  LONGWAVE
# undef  DIURNAL_SRFLUX /* "impose shortwave radiation local diurnal cycle" */
# undef  ANA_SRFLUX
# undef  ICE_ALB_EC92   /* "albedo computation from Ebert and Curry" */
#endif

#undef   ATM_PRESS      /*Not activated in Dinniman et al.2020; do the same since you're using his SSH at the boundaries.*/
#undef   WIND_MINUS_CURRENT
#undef   RUNOFF         /* Runoff as a second rain field */
#undef   WTYPE_GRID
#undef   SCORRECTION    /* A form of nudging on SSS (optional) */

/* About humdity: ROMS' default behavior is to take as input relative humidity in %, which is then immediately converted to a ratio with the factor 0.01.d0 inside varinfo.dat. The varinfo.dat also proposes another possibility, i.e. to input *specific* humidity in g/kg, in which case there is no scaling (1.0d0 in varinfo.dat). From what I see in Kate Hedstrom's varinfo.dat file, she inputs *specific* humidity in *kg/kg* (not %, nor g/kg) with no scaling (1.0d0 inside varinfo.dat), and then defines SPECIFIC_HUMIDITY or CORE_FORCING to make things clear to ROMS/Nonlinear/bulk_flux.F. Your atmospheric forcing files provide specific humidity in kg/kg, and you have also modified the default Rutgers varinfo.dat file to mimic Kate's varinfo.dat. */

/* Sea ice */

#define  ICE_MODEL
#ifdef   ICE_MODEL
# define ICE_THERMO          /* Include sea ice thermodynamics */
# define ICE_MK              /* Specifically use Mellor-Kantha thermodynamics */
# define ICE_BULK_FLUXES
# define ICE_CONVSNOW
# define ICE_MOMENTUM        /* "momentum component* */
# define ICE_EVP             /* elastic-viscous-plastic rheology */
# define ICE_ADVECT          /* "advection of ice tracers" */
# define ICE_SMOLAR          /* "MPDATA advection scheme" */
# define ICE_UPWIND          /* "upwind advection scheme" (skips antidiffusive step when defined) */
# define ICE_MOM_BULK        /* If defined, use sea ice-water drag coefficient from file ice.in. */
# define LIMIT_WATER_STRESS_IN_UNRESOLVED_SURFACE_LAYER

# ifdef SCORRECTION
#  define NO_SCORRECTION_ICE /*If defined, limit SCORRECTION to ice-free areas.*/
# endif

# undef  ICE_I_O             /* "shortwave going to heat ice" */
# undef  CCSM_ICE_SHORTWAVE  /* Doesn't necessarily require CCSM_FLUXES. */
# undef  ICE_DIAGS           /* "ice thermodynamic diagnostics" */
# undef  ANA_ICE
# undef  SNOWFALL            /* Distinguish between snowfall and rain */
# undef  ICE_SHALLOW_LIMIT   /* Some type of behavior for shallow waters. */
# undef  OUTFLOW_MASK        /* "Hibler style outflow cells" */
# undef  FASTICE_CLIMATOLOGY
# undef  ICE_STRENGTH_QUAD   /* Sea ice strength a quadratic function of thickness. */
#endif

/* Boundary conditions. */

#define  RADIATION_2D
#undef   ANA_NUDGCOEF

/* ROMS quirks. */

#define  ANA_BSFLUX
#define  ANA_BTFLUX

/* Tides. */

#ifdef   LTIDES
# define SSH_TIDES
# define UV_TIDES
# define ADD_FSOBC
# define ADD_M2OBC

# if defined AVERAGES && !defined USE_DEBUG
#  undef FILTERED
# endif
# undef  RAMP_TIDES
# undef  TIDES_ASTRO
# undef  POT_TIDES
#endif

/*  Biological model options. */

#ifdef   BIOLOGY
# define NPZD_IRON
# define ANA_SPFLUX
# define ANA_BPFLUX

# undef  BIO_UMAINE
#endif

#if defined NPZD_IRON
# define    IRON_LIMIT
# define    NPZD_IRON_HOLLING_GRAZING /*Replace Ivlev with grazing as Fennel et al. 2006*/
# if defined IRON_LIMIT
#  define   SPECIFIC_DFE_SOURCES
#  define   NPZD_IRON_GROWTH_FUNCTION_DFE
#  define   NPZD_IRON_PFE
#  if defined NPZD_IRON_PFE
#    define NPZD_IRON_PAR
#    define NPZD_IRON_TWO_DETRITUS
#  endif
# endif
#endif

#ifdef   BIO_UMAINE
# define CARBON
# define OXYGEN
# define PRIMARY_PROD
# define SINK_OP2
# define TALK_NONCONSERV
# define OPTIC_MANIZZA
# define ANA_BPFLUX        /* Analytical bottom passive tracers fluxes */
# define ANA_SPFLUX        /* Analytical surface passive tracers fluxes */
# define IRON_LIMIT        /* Add iron as passive Nth tracer */
# define IRON_RELAX

# undef  IRON_RSIN
# undef  OPTIC_UMAINE
#endif

/* Point sources. */

#undef   ONE_TRACER_SOURCE /* One concentration for all rivers, all vertical levels. */

/* Passive tracers. */

#undef   T_PASSIVE
#ifdef   T_PASSIVE
# define ANA_BPFLUX        /* Analytical bottom passive tracers fluxes */
# define ANA_SPFLUX
# define ANA_PASSIVE
# define TRC_PSOURCE
# define ANA_TRC_PSOURCE
# define AGE_MEAN
#endif

/* Outputs. */

#define  AVERAGES        /*Necessary for AVG files*/
#define  HDF5
#define  DEFLATE

#undef   DIAGNOSTICS_TS
#undef   DIAGNOSTICS_UV
#undef   PERFECT_RESTART
#undef   NO_WRITE_GRID
#undef   OUT_DOUBLE
#undef   AVERAGES2       /*An optional, second set of AVG files*/

#ifndef  PERFECT_RESTART
# define RST_SINGLE
#endif

